using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace DataColumn_DataRow
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button button1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

        public Form1() {
            try{
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                // Create a DataTable. 
                DataTable NameTable = new DataTable("Names");
                // Create a DataColumn and set various properties. 
                DataColumn FirstNameCol = new DataColumn();
                FirstNameCol.DataType = System.Type.GetType("System.String");
                FirstNameCol.AllowDBNull = true;
                FirstNameCol.Caption = "Author's First Name";
                FirstNameCol.ColumnName = "FirstName";
                FirstNameCol.DefaultValue = "Fred";
                FirstNameCol.MaxLength = 20;
                // Add the column to the table. 
                NameTable.Columns.Add(FirstNameCol);
       
                DataRow myRow;
      
                string NameIn;
                for (int i = 0; i <= 9; i++) {
                    myRow = NameTable.NewRow();
                    if (myRow.HasVersion(DataRowVersion.Default)) {
                        Debug.WriteLine("Pre-set value default:" + myRow[0, DataRowVersion.Default].ToString());
                    }
            
                    switch (i) {
                        case 0:
                            myRow["FirstName"] =  "Fred";
                            break;
                        case 1:
                            myRow["FirstName"] =  "Betty";
                            break;
                        case 2:
                            myRow["FirstName"] =  "Sam";
                            break;
                        case 3:
                            myRow["FirstName"] =  "Victoria";
                            break;
                        case 4:
                            myRow["FirstName"] =  "Bill";
                            break;
                        case 5:
                            myRow["FirstName"] =  "Marilyn";
                            break;
                        case 6:
                            myRow["FirstName"] =  "Jim";
                            break;
                        case 7:
                            myRow["FirstName"] =  "Mary";
                            break;
                        case 8:
                            myRow["FirstName"] =  "Alice";
                            break;
                        default:
                            myRow["FirstName"] = null;
                            break;
                    }     

                    // Be sure to add the new row to the DataRowCollection. 
                    NameTable.Rows.Add(myRow);
                    if( NameTable.Rows[i].HasVersion(DataRowVersion.Default)) {
                        Debug.WriteLine("Pre-edit default:" + NameTable.Rows[i][0, DataRowVersion.Default].ToString());
                    }
                }
                
                NameTable.Rows[0].BeginEdit();
                NameTable.Rows[0][0] = "New Name";
                if (NameTable.Rows[0].HasVersion(DataRowVersion.Proposed)) {
                
                    Debug.WriteLine("Proposed:" + NameTable.Rows[0][0, DataRowVersion.Proposed].ToString());
                }
                if (NameTable.Rows[0].HasVersion(DataRowVersion.Original)) {
                    Debug.WriteLine("Original:" + NameTable.Rows[0][0, DataRowVersion.Original].ToString());
                }
                if (NameTable.Rows[0].HasVersion(DataRowVersion.Current)) {
                    Debug.WriteLine("Current:" + NameTable.Rows[0][0, DataRowVersion.Current].ToString());
                }
                if (NameTable.Rows[0].HasVersion(DataRowVersion.Default)) {
                    Debug.WriteLine("Default:" + NameTable.Rows[0][0, DataRowVersion.Default].ToString());
                }
                NameTable.Rows[0].AcceptChanges();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.button1 = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(112, 112);
            this.button1.Name = "button1";
            this.button1.TabIndex = 0;
            this.button1.Text = "Done";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(292, 266);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.button1});
            this.Name = "Form1";
            this.Text = "Form1";
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private void button1_Click(object sender, System.EventArgs e) {
            try{
            }
            catch (Exception ex) {
            MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
	}
}
